<?php
// trade_alerts.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Handle trading alerts creation
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $currency_pair = $_POST['currency_pair'];
    $target_price = $_POST['target_price'];
    $direction = $_POST['direction'];

    $stmt = $pdo->prepare("INSERT INTO trade_alerts (user_id, currency_pair, target_price, direction, created_at) VALUES (:user_id, :currency_pair, :target_price, :direction, NOW())");
    $stmt->execute([
        'user_id' => $user_id,
        'currency_pair' => $currency_pair,
        'target_price' => $target_price,
        'direction' => $direction,
    ]);

    $success = "Trading alert created successfully.";
}

// Fetch user alerts
$stmt = $pdo->prepare("SELECT * FROM trade_alerts WHERE user_id = :user_id ORDER BY created_at DESC");
$stmt->execute(['user_id' => $user_id]);
$alerts = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Trading Alerts</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="currency_pair">Currency Pair:</label>
            <input type="text" name="currency_pair" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="target_price">Target Price:</label>
            <input type="number" name="target_price" step="0.0001" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="direction">Direction:</label>
            <select name="direction" class="form-control">
                <option value="above">Above</option>
                <option value="below">Below</option>
            </select>
        </div>
        <input type="submit" value="Create Alert" class="btn btn-primary">
    </form>
    <hr>
    <h2>Your Alerts</h2>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Currency Pair</th>
                <th>Target Price</th>
                <th>Direction</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($alerts as $alert): ?>
                <tr>
                    <td><?php echo $alert['currency_pair']; ?></td>
                    <td><?php echo $alert['target_price']; ?></td>
                    <td><?php echo ucfirst($alert['direction']); ?></td>
                    <td><?php echo $alert['created_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>