<?php
// trade_search.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Handle trade search filters
$filter_trade_type = $_GET['trade_type'] ?? '';
$filter_currency_pair = $_GET['currency_pair'] ?? '';
$filter_start_date = $_GET['start_date'] ?? '';
$filter_end_date = $_GET['end_date'] ?? '';

// Build the query
$query = "SELECT * FROM trades WHERE user_id = :user_id";
$params = ['user_id' => $user_id];

if ($filter_trade_type) {
    $query .= " AND trade_type = :trade_type";
    $params['trade_type'] = $filter_trade_type;
}

if ($filter_currency_pair) {
    $query .= " AND currency_pair = :currency_pair";
    $params['currency_pair'] = $filter_currency_pair;
}

if ($filter_start_date) {
    $query .= " AND trade_date >= :start_date";
    $params['start_date'] = $filter_start_date;
}

if ($filter_end_date) {
    $query .= " AND trade_date <= :end_date";
    $params['end_date'] = $filter_end_date;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$trades = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Advanced Trade Search</h1>
    <form method="GET" action="">
        <div class="form-group">
            <label for="trade_type">Trade Type:</label>
            <select name="trade_type" class="form-control">
                <option value="">All</option>
                <option value="buy" <?php echo $filter_trade_type == 'buy' ? 'selected' : ''; ?>>Buy</option>
                <option value="sell" <?php echo $filter_trade_type == 'sell' ? 'selected' : ''; ?>>Sell</option>
            </select>
        </div>
        <div class="form-group">
            <label for="currency_pair">Currency Pair:</label>
            <input type="text" name="currency_pair" class="form-control" value="<?php echo htmlspecialchars($filter_currency_pair); ?>">
        </div>
        <div class="form-group">
            <label for="start_date">Start Date:</label>
            <input type="date" name="start_date" class="form-control" value="<?php echo $filter_start_date; ?>">
        </div>
        <div class="form-group">
            <label for="end_date">End Date:</label>
            <input type="date" name="end_date" class="form-control" value="<?php echo $filter_end_date; ?>">
        </div>
        <input type="submit" value="Search" class="btn btn-primary mt-3">
    </form>
    <hr>
    <h2>Trade History</h2>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>Trade Type</th>
                <th>Currency Pair</th>
                <th>Amount</th>
                <th>Profit/Loss</th>
                <th>Trade Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($trades as $trade): ?>
                <tr>
                    <td><?php echo $trade['id']; ?></td>
                    <td><?php echo ucfirst($trade['trade_type']); ?></td>
                    <td><?php echo $trade['currency_pair']; ?></td>
                    <td>$<?php echo $trade['amount']; ?></td>
                    <td>$<?php echo $trade['profit_loss']; ?></td>
                    <td><?php echo $trade['trade_date']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>