<?php
// trade_summary.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user trades and calculate performance summary
$stmt = $pdo->prepare("SELECT trade_type, amount, profit_loss FROM trades WHERE user_id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$trades = $stmt->fetchAll();

$total_trades = count($trades);
$total_profit = 0;
$total_loss = 0;

foreach ($trades as $trade) {
    if ($trade['profit_loss'] > 0) {
        $total_profit += $trade['profit_loss'];
    } else {
        $total_loss += abs($trade['profit_loss']);
    }
}

?>

<div class="container mt-5">
    <h1>Trading Performance Summary</h1>
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Trades</h5>
                    <p class="card-text"><?php echo $total_trades; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Profit</h5>
                    <p class="card-text">$<?php echo number_format($total_profit, 2); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-danger mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Loss</h5>
                    <p class="card-text">$<?php echo number_format($total_loss, 2); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>