<?php
// transaction_history.php

include('../includes/db.php');
include('../includes/header.php');
require '../vendor/autoload.php'; // PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user's transaction history
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = :user_id ORDER BY transaction_date DESC");
$stmt->execute(['user_id' => $user_id]);
$transactions = $stmt->fetchAll();

// Handle transaction export request
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['export'])) {
    // Create an Excel file with transaction data
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Set transaction data header
    $sheet->setCellValue('A1', 'Transaction ID');
    $sheet->setCellValue('B1', 'Transaction Type');
    $sheet->setCellValue('C1', 'Amount');
    $sheet->setCellValue('D1', 'Date');

    // Add transaction data
    $rowIndex = 2;
    foreach ($transactions as $transaction) {
        $sheet->setCellValue('A' . $rowIndex, $transaction['id']);
        $sheet->setCellValue('B' . $rowIndex, $transaction['transaction_type']);
        $sheet->setCellValue('C' . $rowIndex, $transaction['amount']);
        $sheet->setCellValue('D' . $rowIndex, $transaction['transaction_date']);
        $rowIndex++;
    }

    // Output Excel file
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="transaction_history.xlsx"');
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit();
}

?>

<div class="container mt-5">
    <h1>Transaction History</h1>
    <form method="POST" action="">
        <input type="hidden" name="export" value="1">
        <input type="submit" value="Export as Excel" class="btn btn-primary mb-3">
    </form>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Transaction Type</th>
                <th>Amount</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($transactions as $transaction): ?>
                <tr>
                    <td><?php echo $transaction['id']; ?></td>
                    <td><?php echo ucfirst($transaction['transaction_type']); ?></td>
                    <td>$<?php echo $transaction['amount']; ?></td>
                    <td><?php echo $transaction['transaction_date']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>