<?php
// user/wallet.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');
include('../includes/functions.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch wallet balance
$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$wallet_balance = $stmt->fetchColumn();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['transaction_type'] == 'withdraw') {
    $amount = $_POST['amount'];

    if ($amount > $wallet_balance) {
        $error = "Insufficient balance.";
    } else {
        // Insert withdrawal request
        $stmt = $pdo->prepare("INSERT INTO withdrawals (user_id, amount, status, request_date) VALUES (:user_id, :amount, 'pending', NOW())");
        $stmt->execute(['user_id' => $user_id, 'amount' => $amount]);

        $success = "Withdrawal request submitted successfully and is pending admin approval.";
    }
}

?>

<div class="container mt-5">
    <h2>Wallet Management</h2>
    <p><strong>Current Wallet Balance:</strong> $<?php echo $wallet_balance; ?></p>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <input type="hidden" name="transaction_type" value="withdraw">
        <div class="form-group">
            <label for="amount">Withdraw Amount:</label>
            <input type="number" name="amount" step="0.01" class="form-control" required>
        </div>
        <input type="submit" value="Withdraw" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>