<?php
// wallet_transfer.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch current wallet balances
$stmt = $pdo->prepare("SELECT trading_balance, savings_balance FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$user = $stmt->fetch();

// Handle wallet transfer request
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $from_wallet = $_POST['from_wallet'];
    $to_wallet = $_POST['to_wallet'];
    $amount = $_POST['amount'];

    if ($from_wallet == $to_wallet) {
        $error = "You cannot transfer funds between the same wallet.";
    } elseif ($amount <= 0) {
        $error = "Please enter a valid amount.";
    } elseif ($from_wallet == 'trading' && $amount > $user['trading_balance']) {
        $error = "Insufficient trading balance.";
    } elseif ($from_wallet == 'savings' && $amount > $user['savings_balance']) {
        $error = "Insufficient savings balance.";
    } else {
        // Process the transfer
        if ($from_wallet == 'trading') {
            $stmt = $pdo->prepare("UPDATE users SET trading_balance = trading_balance - :amount, savings_balance = savings_balance + :amount WHERE id = :user_id");
        } else {
            $stmt = $pdo->prepare("UPDATE users SET savings_balance = savings_balance - :amount, trading_balance = trading_balance + :amount WHERE id = :user_id");
        }
        $stmt->execute(['amount' => $amount, 'user_id' => $user_id]);
        $success = "Transfer completed successfully.";
    }
}

?>

<div class="container mt-5">
    <h1>Wallet Transfer</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="from_wallet">From Wallet:</label>
            <select name="from_wallet" class="form-control" required>
                <option value="trading">Trading Balance ($<?php echo number_format($user['trading_balance'], 2); ?>)</option>
                <option value="savings">Savings Balance ($<?php echo number_format($user['savings_balance'], 2); ?>)</option>
            </select>
        </div>
        <div class="form-group">
            <label for="to_wallet">To Wallet:</label>
            <select name="to_wallet" class="form-control" required>
                <option value="savings">Savings Balance</option>
                <option value="trading">Trading Balance</option>
            </select>
        </div>
        <div class="form-group">
            <label for="amount">Amount:</label>
            <input type="number" name="amount" step="0.01" class="form-control" required>
        </div>
        <input type="submit" value="Transfer" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>